import { assert } from '../util';
import { op } from './operation';
import { pad } from './pad';
/**
 * Pads a `tf.Tensor4D` with a given value and paddings. See `pad` for details.
 */
function pad4d_(x, paddings, constantValue = 0) {
    assert(paddings.length === 4 && paddings[0].length === 2 &&
        paddings[1].length === 2 && paddings[2].length === 2 &&
        paddings[3].length === 2, () => 'Invalid number of paddings. Must be length of 2 each.');
    return pad(x, paddings, constantValue);
}
export const pad4d = /* @__PURE__ */ op({ pad4d_ });
//# sourceMappingURL=data:application/json;base64,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